(function() {
    tinymce.create('tinymce.plugins.smt_panel', {
        init : function(ed, url) {
			
			/**
			* Google Map
			*/
			ed.addCommand( 'insertGglMap', function() {
				makeWindow( {
					'title':'Insert Google Map',
					'saveBtn':'Insert',
					'atts':{
						'address':{
							'value':'',
							'type':'text',
							'title':'Address'
						},
						'type':{
							'value':'ROADMAP',
							'values':{
								'ROADMAP':'Road map view',
								'SATELLITE':'Google Earth satellite images',
								'HYBRID':'Mixture of normal and satellite views',
								'TERRAIN':'Physical map based on terrain information. '
							},
							'type':'select',
							'title':'Type'
						},
						'zoom':{
							'value':'',
							'type':'text',
							'title':'Zoom'
						}
					},
					'saveClick':function( atts, e ) {
						ed.execCommand( 'mceInsertContent', false, '[gglmap address="' + atts.address + '" type="' + atts.type + '" zoom="' + parseInt( atts.zoom ) + '"][/gglmap]' );
						return true;
					}
				});
			});
            ed.addButton( 'smt_gglmap', {
                title : 'Google Map',
                image : url+'/../includes/images/shortcode_gglmap.png',
                cmd: 'insertGglMap'
            });

			

			
			/**
			* Tooltip
			*/
			ed.addCommand( 'insertTooltip', function() {
				makeWindow( {
					'title':'Insert Tooltip',
					'saveBtn':'Insert',
					'atts':{
						'hint':{
							'value':'',
							'type':'text',
							'title':'Hint text'
						}
					},
					'saveClick':function( atts, e ) {
						var s = ed.selection.getContent();
						if ( s == '' ) 
							s = 'Tooltip';
						ed.execCommand( 'mceInsertContent', false, '[tooltip hint="' + atts.hint + '"]' + s + '[/tooltip]' );
						
						return true;
					}
				});
			});
            ed.addButton( 'smt_tooltip', {
                title : 'Tooltip',
                image : url+'/../includes/images/shortcode_tooltip.png',
                cmd: 'insertTooltip'
            });
        },
        createControl : function(n, cm) {
            return null;
        },
        getInfo : function() {
            return {
                longname : "SMThemes.com Shortcodes",
                author : 'SMThemes.com',
                authorurl : 'http://smthemes.com/',
                infourl : 'http://smthemes.com/',
                version : "2.0"
            };
        }
    });
    tinymce.PluginManager.add( 'smt_panel', tinymce.plugins.smt_panel );
})();













