<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 */
 
global $SMTheme;
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
<?php
	$tn_id = get_post_thumbnail_id( $post->ID );
	$img = wp_get_attachment_image_src( $tn_id, 'post-thumbnail' );
	$width = ($img[1]>0)?'width:100%':'';
	
?>
		
	<!-- ========== Post Featured Image ========== -->
	<div style="<?php echo $width; ?>" class="date_container <?php if (has_post_thumbnail()) { echo 'has_thumbnail';} else echo 'no_thumbnail'; ?>">
	<?php the_post_thumbnail(
				array( 663, 189),
				array("class" => "featured_image")
	); ?>
	<span class='post-date'><?php echo get_the_date('d').'<br />'.'<span class="post-date-year">'.get_the_date( 'M' ).'</span>'; ?></span>
	</div>
	<div class="entry-inner">
	<!-- ========== Post Title ========== -->
	<?php  //Title
		if (!is_single()&&!is_page()) { ?>
			<h2 class='entry-title'><a href="<?php the_permalink(); ?>" title="<?php printf( $SMTheme->_( 'permalink' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
		<?php } else { ?>
			<h1 class='entry-title'><?php the_title(); ?></h1>
	<?php } ?>
	
	
	
	
	<!-- ========== Post content  ========== -->
	<?php if ( !is_single() ) : ?>
		
		<!-- ========== Post content in posts feed ========== -->
		<div class="entry-summary">
			<?php smtheme_excerpt('echo=1');?>
			<!-- ========== Post Meta ========== -->
	<div class="entry-meta">
		
		<img src="<?php echo get_template_directory_uri(); ?>/images/author.png" />
				<?php the_author(' '); ?>
				
		
		<img src="<?php echo get_template_directory_uri(); ?>/images/date.png" /><span class='post-date'><?php echo get_the_date(); ?></span>
		
				
				<img src="<?php echo get_template_directory_uri(); ?>/images/categories.png" />
				
				<?php the_category(' '); 
				
				if(comments_open( get_the_ID() ))  {
                    ?> <img src="<?php echo get_template_directory_uri(); ?>/images/comments.png" /><span class='post-comments'><?php comments_popup_link( $SMTheme->_( 'noresponses' ), $SMTheme->_( 'oneresponse' ), $SMTheme->_( 'multiresponse' ) ); ?></span>
				<?php } 
				
				?>
	</div>
			
		</div><!-- .entry-summary -->
	
	<?php else : ?>
	
		<!-- ========== Post content in single post page ========== -->
		<div class="entry-content">
			<?php
				the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'letheme' ) );
				wp_link_pages( array(	
					'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'letheme' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
			?>
			
		</div><!-- .entry-content -->
		
	<?php endif; ?>
	
	
	
	
	
	</div>
	<?php if ( !is_single() ) : ?>
	<a href='<?php the_permalink(); ?>' class='readmore'><?php echo $SMTheme->_( 'readmore' ); ?><span class="icon"></span></a>
	<?php endif; ?>
	<div class="clear"></div>
</article><!-- #post-## -->
