<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 */
 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( ); ?>>
	
	<?php echo get_avatar( get_the_author_meta( 'ID' ), 60 ); ?> 
	
	<!-- ========== Post Featured Image ========== -->
	<?php if ( has_post_thumbnail() ) { // if there is featured image for this post you may wrapper for it ?>
		
		<?php the_post_thumbnail(
				'post-thumbnail',
				array( 'class' => 'featured_image', 'style' => smt_thumbnail_style() )
			); ?>
			
	<?php } ?>	
	
	<!-- ========== Post content in single post page ========== -->
		<div class="entry-content content-block">
					
	<!-- ========== Post Meta ========== -->
	<div class="entry-meta">
		<span class='post-date updated'>
			<span class="month"><?php echo get_the_date('M'); ?></span>
			<?php echo get_the_date('d'); ?>
		</span> 
		<span class='post-categories'><?php the_category(', '); ?></span>
		<?php if(comments_open( get_the_ID() )) { ?>
			<span class='post-comments'><span class="comment"><?php comments_popup_link( smt_translate( 'noresponses' ), smt_translate( 'oneresponse' ), smt_translate( 'multiresponse' ) ); ?></span><span class="icon">&#xf086;</span></span>
		<?php } edit_post_link( smt_translate( 'edit' ), '     |     <span class="edit-link">', '</span>' ); ?>

			<div class="clear"></div>		
	</div>
		
	<!-- ========== Post Title ========== -->
	<?php  //Title
		if (!is_single()&&!is_page()) { ?>
			<h2 class='entry-title'><a href="<?php the_permalink(); ?>" title="<?php printf( smt_translate( 'permalink' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
		<?php } else { ?>
			<h1 class='entry-title'><?php the_title(); ?></h1>
	<?php } ?>	
	
	<!-- ========== Post content  ========== -->
	<?php if ( !is_single() ) : ?>
		
			<?php if( smt_getOption( 'layout', 'cuttxton' ) ) {
				if ( ! post_password_required() ) { 
					smt_excerpt( 'echo=1' );
				} else the_content( );
			}  else { 
				the_content(); 
			} ?>
			<a href='<?php the_permalink(); ?>' class='button'><?php echo smt_translate( 'readmore' ); ?></a>
	
			<div class="clear"></div>
			
	<?php else : ?>
	
	
			<?php
				the_content( smt_translate( 'readmore' ) );
				wp_link_pages( array(	
					'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'smtheme' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
			?>
		
		
		<!-- ========== Post tags in single post page ========== -->
		<?php 
			$tag_list = get_the_tag_list( '', ', ' );
			if ( $tag_list ) { ?>
				<div class="tags content-block"><?php echo smt_translate( 'tags' ); ?>:&nbsp;<?php echo $tag_list; ?></div>
			<?php }
		?>
		
		
		<!-- ========== Related Posts in single post page ========== -->
		<?php get_template_part( 'relatedposts' ); ?>
		
		
		<!-- ========== Post comments in single post page ========== -->
		<?php 
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
		?>
		
		
	<?php endif; ?>
	
			<div class="clear"></div>
	
	</div><!-- .entry-content -->
	
	
	<div class="clear"></div>
</article><!-- #post-## -->
