<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 */
 
global $SMTheme;
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<div class="border_post">
	
	
	<!-- ========== Post Featured Image ========== -->
	<div class="date_container <?php echo $SMTheme->get( 'layout','imgpos' );?> <?php if (has_post_thumbnail()) echo 'has_thumbnail'; ?>">
	<?php the_post_thumbnail(
				array($SMTheme->get( 'layout', 'imgwidth' ), $SMTheme->get( 'layout', 'imgheight' )),
				array("class" => $SMTheme->get( 'layout','imgpos' ) . " featured_image")
				
	); ?>
	
	<span class='post-date'><?php echo get_the_date( 'Y\<\b\r \/\>M d' ); ?></span>
	</div>
	
	<!-- ========== Post Title ========== -->
	<?php  //Title
		if (!is_single()&&!is_page()) { ?>
			<h2 class='entry-title'><a href="<?php the_permalink(); ?>" title="<?php printf( $SMTheme->_( 'permalink' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h2>
		<?php } else { ?>
			<h1 class='entry-title'><?php the_title(); ?></h1>
	<?php } ?>
	
	
	
	<!-- ========== Post content  ========== -->
	<?php if ( !is_single() ) : ?>
		
		<!-- ========== Post content in posts feed ========== -->
		<div class="entry-summary">
			<?php smtheme_excerpt('echo=1');?>
			<a href='<?php the_permalink(); ?>' class='readmore'><?php echo $SMTheme->_( 'readmore' ); ?></a>
		</div><!-- .entry-summary -->
	
	<?php else : ?>
	
		<!-- ========== Post content in single post page ========== -->
		<div class="entry-content">
			<?php
				the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'letheme' ) );
				wp_link_pages( array(	
					'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'letheme' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
			?>
		</div><!-- .entry-content -->
		
	<?php endif; ?>
	<div class="border_meta">
	<!-- ========== Post Meta ========== -->
	
	<div class="entry-meta">
		
				<img src="<?php echo get_template_directory_uri(); ?>/images/author.png" />
				<?php the_author(' '); ?>
				
				<img src="<?php echo get_template_directory_uri(); ?>/images/comments.png" />
				<?php if(comments_open( get_the_ID() ))  {
                    ?> <span class='post-comments'><?php comments_popup_link( $SMTheme->_( 'noresponses' ), $SMTheme->_( 'oneresponse' ), $SMTheme->_( 'multiresponse' ) ); ?></span>
				<?php } ?>
				
				
	</div>
	</div>
		
	<div class="clear"></div>
	</div>
</article><!-- #post-## -->
